/*

	GEARS GameScript Lexer script file

*/

elexfilename	= "../event/ScriptLex";
elexname		= CScriptLex;

include = 
{*

#include "eventdlldef.h"

*};

define = 
{*

*};


///////////////////////////////////////////////////////////
// Script Begins here!
///////////////////////////////////////////////////////////

NEWLINE			(ignore)	{:\r?\n:}				{* NEWLINE; *};
WHITESPACE		(ignore)	{:[" "\t]+:};
COMMENTLINE		(ignore)	{://([\r\n]~)*\r?\n:}	{* NEWLINE; *};
COMMENTBLOCK	(ignore)	{:/#*((/#*~)|([/#*]~)|(#*/~))*#*/:}
{*
	const char* text = TEXT;
	int len = strlen(text), i;

	for(i=0;i<len;i++) {
		if(text[i] == '\n') NEWLINE;
	}
*};


/////////////////////////////////////////////
// this token must be defined before CHARS

NAME			{:NAME:};
TYPE			{:TYPE:};
DESC			{:DESC:};
START			{:START:};

STATE			{:STATE:};

ENTER			{:ENTER:};
LEAVE			{:LEAVE:};
BEGIN			{:BEGIN:};
END				{:END:};


FPS				{:FPS:};


TRUE			{:true:};
FALSE			{:false:};

GLOBAL			{:global:};
DELAYED			{:delayed:};

IF				{:if:};
ELSE			{:else:};
GOTO			{:goto:};
BREAK			{:break:};

/////////////////////////////////////////////

COMMA			{:,:};
COLON			{:":":};
MINUS			{:"-":};
AND				{:and:};
OR				{:or:};
LPAREN			{:#(:};
RPAREN			{:#):};


INTEGER			{:[#+#-]?(0-9)+:}						(value)	{* RETURN (NEW_INDIRECT(SEVT_ValueType, new SEVT_ValueType(atoi(TEXT)))); *};
FLOAT			{:[#+#-]?(0-9)+.(0-9)+:}				(value)	{* RETURN (NEW_INDIRECT(SEVT_ValueType, new SEVT_ValueType((float)atof(TEXT)))); *};
CHARS			{:[(a-z)(A-Z)#_]+[(a-z)(A-Z)#_(0-9)]+:}	(value) {* RETURN (NEW_INDIRECT(SEVT_ValueType, new SEVT_ValueType(TEXT))); *};
STRING			{:#"[(#")~]*#":}						(value) 
{*
	char* str = new char[strlen(TEXT)+1];

	strcpy(str, TEXT + 1);
	str[strlen(str)-1] = NULL;

	SEVT_ValueType* my_ret = NEW_INDIRECT(SEVT_ValueType, new SEVT_ValueType(str));
	delete[] str;

	RETURN my_ret;
*};

